/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.interpartsserver3.InterpartsServer;
import com.belenus.interpartsserver3.Responder;
import com.belenus.interpartsserver3.ServerDispatcher;
import com.belenus.util.HtmlInfo;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

class ServerDispatcherInfoResponder
extends Responder {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$ServerDispatcherInfoResponder == null ? (class$com$belenus$interpartsserver3$ServerDispatcherInfoResponder = ServerDispatcherInfoResponder.class$("com.belenus.interpartsserver3.ServerDispatcherInfoResponder")) : class$com$belenus$interpartsserver3$ServerDispatcherInfoResponder));
    static /* synthetic */ Class class$com$belenus$interpartsserver3$ServerDispatcherInfoResponder;

    public ServerDispatcherInfoResponder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServerDispatcher serverDispatcher) {
        super(httpServletRequest, httpServletResponse, serverDispatcher);
    }

    public void respond() throws Throwable {
        boolean active;
        boolean allInfo = this.m_serverDispatcher.allowedAdministration(this.m_httpServletRequest);
        this.m_httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = new PrintWriter((OutputStream)this.m_httpServletResponse.getOutputStream());
        HtmlInfo htmlInfo = new HtmlInfo(printWriter);
        htmlInfo.showLeadin(this.m_serverDispatcher.getServerType(), this.m_serverDispatcher.getVersion(), this.m_serverDispatcher.getRevision());
        String problem = this.m_serverDispatcher.getServlet().m_problemStringWriter.toString();
        if (problem.length() > 0) {
            htmlInfo.showProblem(problem);
        }
        htmlInfo.showHeader("Environment", 2);
        long running = (new Date().getTime() - this.m_serverDispatcher.m_startupDate.getTime()) / 1000L;
        htmlInfo.showValue("Startup Date", this.m_serverDispatcher.m_startupDate + " (running for " + running + " seconds)");
        long freemem = Runtime.getRuntime().freeMemory();
        long totalmem = Runtime.getRuntime().totalMemory();
        htmlInfo.showLine(String.valueOf(freemem) + " of " + totalmem + " bytes available");
        htmlInfo.showServletContainer(this.m_serverDispatcher.getServlet());
        htmlInfo.showRequestInformation(this.m_httpServletRequest);
        htmlInfo.showHeader("Client's Server Use", 3);
        InterpartsServer currentInterpartsServer = this.m_serverDispatcher.getInterpartsServer(this.m_httpServletRequest);
        if (currentInterpartsServer != null) {
            String serverName = currentInterpartsServer.getServerName();
            String line = allInfo ? "<b>" + serverName + "<b> <a href=\"server?command=info&server=" + serverName + "\">Info</a>" : "<b>" + serverName + "<b>";
            htmlInfo.showLine(line);
        } else {
            htmlInfo.showLine("No client uses no current server");
        }
        printWriter.flush();
        if (allInfo) {
            htmlInfo.showHeader("Configuration", 2);
            htmlInfo.showSettings(this.m_serverDispatcher.m_configurator);
            htmlInfo.showLog();
            printWriter.flush();
        }
        if (allInfo) {
            htmlInfo.showHeader("Ranges", 2);
            for (int rangeNamesIndex = 0; rangeNamesIndex < this.m_serverDispatcher.m_rangeNames.size(); ++rangeNamesIndex) {
                String range = (String)this.m_serverDispatcher.m_rangeNames.get(rangeNamesIndex);
                htmlInfo.showHeader(range, 3);
                ArrayList rangeServerList = (ArrayList)this.m_serverDispatcher.m_rangesMap.get(range);
                for (int rangeServerListIndex = 0; rangeServerListIndex < rangeServerList.size(); ++rangeServerListIndex) {
                    String serverName = (String)rangeServerList.get(rangeServerListIndex);
                    active = this.m_serverDispatcher.isActive(serverName);
                    String line = "<form method=\"post\" action=\"server\" id=\"form-" + serverName + "\"><b>" + serverName + "<b> <a href=\"server?command=info&server=" + serverName + "\">Info</a> <input type=\"text\" name=\"password\">" + "<input type=\"hidden\" name=\"command\" id=\"command-" + serverName + "\">" + "<input type=\"hidden\" name=\"server\" value=\"" + serverName + "\">" + "<input type=\"button\" value=\"Restart\" onclick=\"document.getElementById('command-" + serverName + "').value='restart'; document.getElementById('form-" + serverName + "').submit();\">" + "<input type=\"button\" value=\"Activate\"" + (active ? " disabled=\"true\"" : " onclick=\"document.getElementById('command-" + serverName + "').value='activate'; document.getElementById('form-" + serverName + "').submit();\"") + ">" + (active ? " <b>active</b>" : "") + "</form>";
                    htmlInfo.showLine(line);
                    printWriter.flush();
                }
            }
            printWriter.flush();
        }
        htmlInfo.showHeader("Servers", 2);
        boolean alive = true;
        for (int serverNamesIndex = 0; serverNamesIndex < this.m_serverDispatcher.m_serverNames.size(); ++serverNamesIndex) {
            String serverName = (String)this.m_serverDispatcher.m_serverNames.get(serverNamesIndex);
            InterpartsServer interpartsServer = (InterpartsServer)this.m_serverDispatcher.m_serverMap.get(serverName);
            htmlInfo.showHeader(serverName, 3);
            if (interpartsServer == null) {
                htmlInfo.showLine("<b><font color=\"#FF2020\">Server not set</font></b>");
            } else {
                String line;
                String reference = allInfo ? "server?command=info&server=" + serverName : "javascript:;";
                active = this.m_serverDispatcher.isActive(serverName);
                htmlInfo.showValue("Server Name", interpartsServer.getServerName());
                htmlInfo.showValue("Class Name", interpartsServer.getClass().getName());
                htmlInfo.showValue("Server Type", interpartsServer.getServerType());
                htmlInfo.showValue("Version", interpartsServer.getVersion() + " - Revision " + interpartsServer.getRevision());
                Throwable startupError = interpartsServer.getStartupError();
                if (startupError != null) {
                    line = "<a href=\"" + reference + "\"><b><font color=" + "\"#FF2020\"" + ">Error on Startup</font></b></a>";
                    alive &= !active;
                } else {
                    try {
                        interpartsServer.checkAvailability();
                        line = "<a href=\"" + reference + "\"><b><font color=" + "\"#A0D600\"" + ">Running</font></b></a>";
                    }
                    catch (Throwable throwable) {
                        line = "<a href=\"" + reference + "\"><b><font color=" + "\"#FF2020\"" + ">Not running</font></b></a>";
                        alive &= !active;
                    }
                }
                htmlInfo.showLine(line);
            }
            printWriter.flush();
        }
        printWriter.flush();
        htmlInfo.showHeader("Summary", 2);
        String line = alive ? "<table><tr height=\"40\"><td width=\"40\" bgcolor=\"#A0D600\">&nbsp;</td><td><b><font color=\"#A0D600\">&nbsp;System is alive</font></b></td></tr></table>" : "<table><tr height=\"40\"><td width=\"40\" bgcolor=\"#FF2020\">&nbsp;</td><td><b><font color=\"#FF2020\">&nbsp;System needs maintenance</font></b></td></tr></table>";
        htmlInfo.showLine(line);
        htmlInfo.showLeadout();
        printWriter.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

